/**
 * @since 2.0.0
 */
import * as internal from "./internal/channel/mergeStrategy.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const MergeStrategyTypeId = internal.MergeStrategyTypeId;
/**
 * @since 2.0.0
 * @category constructors
 */
export const BackPressure = internal.BackPressure;
/**
 * @since 2.0.0
 * @category constructors
 */
export const BufferSliding = internal.BufferSliding;
/**
 * Returns `true` if the specified value is a `MergeStrategy`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isMergeStrategy = internal.isMergeStrategy;
/**
 * Returns `true` if the specified `MergeStrategy` is a `BackPressure`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isBackPressure = internal.isBackPressure;
/**
 * Returns `true` if the specified `MergeStrategy` is a `BufferSliding`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isBufferSliding = internal.isBufferSliding;
/**
 * Folds an `MergeStrategy` into a value of type `A`.
 *
 * @since 2.0.0
 * @category folding
 */
export const match = internal.match;
//# sourceMappingURL=MergeStrategy.js.map