"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.signToken = signToken;
exports.verifyToken = verifyToken;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const env_1 = require("../config/env");
const ms_1 = __importDefault(require("ms"));
/**
 * Signs a JWT access token with the given payload and expiration time.
 * @param payload - The payload to encode in the token.
 * @param expiresIn - Expiration time (default: ACCESS_TOKEN_EXPIRE).
 * @returns Signed JWT token string.
 */
function signToken(payload, expiresIn = env_1.ACCESS_TOKEN_EXPIRE) {
    return jsonwebtoken_1.default.sign(payload, env_1.ACCESS_TOKEN_SECRET, {
        expiresIn: (0, ms_1.default)(expiresIn),
    });
}
/**
 * Verifies a JWT access token.
 * @param token - The JWT token string to verify.
 * @returns Decoded token payload if valid.
 */
function verifyToken(token) {
    return jsonwebtoken_1.default.verify(token, env_1.ACCESS_TOKEN_SECRET);
}
/**
 * Signs a JWT refresh token with the given payload and expiration time.
 * @param payload - The payload to encode in the token.
 * @param expiresIn - Expiration time (default: REFRESH_TOKEN_EXPIRE).
 * @returns Signed JWT refresh token string.
 */
/**
 * Generates a JWT token for email verification.
 * @param email - The user's email address.
 * @returns Signed JWT email verification token.
 */
/**
 * Verifies a JWT email verification token.
 * @param token - The JWT token string to verify.
 * @returns Decoded payload with email if valid, otherwise null.
 */
