"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authRouter = void 0;
// src/routes/authRoute.ts
const express_1 = require("express");
const authController_1 = require("../controllers/authController");
const auth_1 = require("../middleware/auth");
const router = (0, express_1.Router)();
// ✅ Define routes BEFORE exporting
router.post("/register", authController_1.authController.register);
router.post("/login", authController_1.authController.signIn);
router.put("/password", auth_1.authenticate, authController_1.authController.changePassword);
exports.authRouter = router;
// const router = Router();
// export const usersRouter = router;
// usersRouter.post("/patientDistribution", authController.register);
