"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.adminRouter = void 0;
// src/routes/adminRoute.ts
const express_1 = require("express");
const adminController_1 = require("../controllers/adminController");
const auth_1 = require("../middleware/auth");
const router = (0, express_1.Router)();
// ✅ Define routes BEFORE exporting
router.get("/users", auth_1.authenticate, adminController_1.adminController.getUsers);
router.get("/users/details/:id", auth_1.authenticate, adminController_1.adminController.getUserDetails);
router.get("/users/info", auth_1.authenticate, adminController_1.adminController.userInfo);
router.get("/orders", auth_1.authenticate, adminController_1.adminController.userOrders);
router.put("/order/approve", auth_1.authenticate, adminController_1.adminController.approveOrder);
router.delete("/user/:id", auth_1.authenticate, adminController_1.adminController.deleteUser);
exports.adminRouter = router;
