"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSettings = void 0;
const prisma_1 = require("../lib/prisma");
const jwt_1 = require("../lib/jwt");
exports.getSettings = {
    // ✅ get site settings
    getSettings: async (req, res) => {
        try {
            const { userId, token } = req.body;
            const user = await (0, jwt_1.verifyToken)(token);
            const { searchParams } = new URL(req.url, `${process.env.API_URL}`);
            // timeIsUp from search param
            const timeIsUp = searchParams.get("timeIsUp") === "true";
            // if (!user) {
            //   return new Response(JSON.stringify({ error: "Unauthorized" }), {
            //     status: 401,
            //   });
            // }
            // if (typeof user === "string" || !("id" in user)) {
            //   return new Response(JSON.stringify({ error: "Invalid user payload" }), {
            //     status: 400,
            //   });
            // }
            // if timeIsUp is true update all taskStatus to 0
            if (timeIsUp) {
                await prisma_1.prisma.task.updateMany({
                    where: {
                        userId,
                    },
                    data: {
                        status: "0",
                    },
                });
            }
            return await prisma_1.prisma.user.findUnique({
                where: { id: userId },
                select: {
                    profile: {
                        select: {
                            currentBalance: false,
                            vip: {
                                select: {
                                    name: true,
                                    dailyIncome: true,
                                    incomePerTask: true,
                                    commission: true,
                                },
                            },
                            taskStatus: true,
                        },
                    },
                    task: {
                        select: {
                            id: true,
                            taskInfoId: true,
                            status: true,
                            updatedAt: true,
                        },
                    },
                },
            });
        }
        catch (error) {
            console.error(error);
            return res.status(500).json({ error: "Internal server error" });
        }
    },
};
